// NetStatDlg.cpp : implementation file
//

#include "stdafx.h"
#include "NetStat.h"
#include "NetStatDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CNetStatDlg dialog




CNetStatDlg::CNetStatDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CNetStatDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CNetStatDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST1, list1);
}

BEGIN_MESSAGE_MAP(CNetStatDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


// CNetStatDlg message handlers

BOOL CNetStatDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	RECT r;
	list1.GetWindowRect(&r);

	int szerListy = r.right - r.left;
	int szerKolumny = szerListy / 4;

	list1.InsertColumn(0,L"Protok",LVCFMT_LEFT, szerKolumny, 0);
	list1.InsertColumn(1,L"Adres lokalny",LVCFMT_LEFT, szerKolumny, 0);
	list1.InsertColumn(2,L"Adres obcy",LVCFMT_LEFT, szerKolumny, 0);
	list1.InsertColumn(3,L"Stan",LVCFMT_LEFT, szerKolumny, 0);

	SprawdzPolaczeniaTCP();
	SprawdzGniazdaUDP();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CNetStatDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CNetStatDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CNetStatDlg::SprawdzPolaczeniaTCP()
{
	MIB_TCPTABLE * tcpTable = NULL;
	unsigned long rozmiar = 0;
	in_addr ipAddr;
	CString lokalny,obcy,stan;
	wchar_t wchLokalny[128] = {'\0'}, wchObcy[128]={'\0'};

	if(GetTcpTable(tcpTable,&rozmiar,true) == ERROR_INSUFFICIENT_BUFFER)
	{
		tcpTable = (MIB_TCPTABLE*)malloc(rozmiar);
	}
	if(tcpTable != NULL)
	{
		if(GetTcpTable(tcpTable,&rozmiar,true) == NO_ERROR)
		{
			for(int i=0;i<tcpTable->dwNumEntries;i++)
			{
				int row = list1.GetHeaderCtrl()->GetItemCount() - 1;
				int index = list1.InsertItem(row,L"TCP");

				ipAddr.S_un.S_addr = tcpTable->table[i].dwLocalAddr;
				mbstowcs(wchLokalny,inet_ntoa(ipAddr),128);
				lokalny.AppendFormat(L"%s:%d",wchLokalny,tcpTable->table[i].dwLocalPort);
				list1.SetItem(index, 1, LVIF_TEXT,lokalny, 0, 0, 0, NULL);
				ipAddr.S_un.S_addr = tcpTable->table[i].dwRemoteAddr;
				mbstowcs(wchObcy,inet_ntoa(ipAddr),128);
				obcy.AppendFormat(L"%s:%d",wchObcy,tcpTable->table[i].dwRemotePort);
				list1.SetItem(index, 2, LVIF_TEXT,obcy ,0, 0, 0, NULL);
				switch (tcpTable->table[i].dwState) 
				{
					 case MIB_TCP_STATE_CLOSED:
						 stan.Append(L"Zamknity");
						break;
					case MIB_TCP_STATE_LISTEN:
						stan.Append(L"Nasuch");
						break;
					case MIB_TCP_STATE_ESTAB:
						stan.Append(L"Ustanowiono");
						break;
					case MIB_TCP_STATE_CLOSING:
						stan.Append(L"Zamykanie");
						break;
					default:
						stan.Append(L"Inny stan");
						break;
				}
				list1.SetItem(index, 3, LVIF_TEXT,stan ,0, 0, 0, NULL);
				lokalny.Empty();
				obcy.Empty();
				stan.Empty();
			}
		}
		free(tcpTable);
	}
}
// dla Iphlpapi trzeba doczy Iphlpapi.lib
void CNetStatDlg::SprawdzGniazdaUDP()
{
	MIB_UDPTABLE * udpTable = NULL;
	unsigned long rozmiar = 0;
	in_addr ipAddr;
	CString lokalny;
	wchar_t wchLokalny[128];

	if(GetUdpTable(udpTable,&rozmiar,true) == ERROR_INSUFFICIENT_BUFFER)
	{
		udpTable = (MIB_UDPTABLE*)malloc(rozmiar);
	}
	if(udpTable != NULL)
	{
		if(GetUdpTable(udpTable,&rozmiar,true) == NO_ERROR)
		{
			for(int i=0;i<udpTable->dwNumEntries;i++)
			{
				int row = list1.GetHeaderCtrl()->GetItemCount() - 1;
				int index = list1.InsertItem(row,L"UDP");

				ipAddr.S_un.S_addr = udpTable->table[i].dwLocalAddr;
				mbstowcs(wchLokalny,inet_ntoa(ipAddr),128);
				lokalny.AppendFormat(L"%s:%d",wchLokalny,udpTable->table[i].dwLocalPort);
				list1.SetItem(index, 1, LVIF_TEXT,lokalny, 0, 0, 0, NULL);
				list1.SetItem(index, 2, LVIF_TEXT,L"*.*" ,0, 0, 0, NULL);
				lokalny.Empty();
			}
		}

		free(udpTable);
	}

}